package gov.va.med.mhv.common.api.util;

import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Validator;

public class EsapiXssInputValidationUtil {
	
	private static final org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory.getLog(EsapiXssInputValidationUtil.class);
	
	private static final String ICN_CHECKSUM_MATCH_PATTERN ="ICN_CHECKSUM_MATCH_PATTERN";
	
	public static boolean validateInputIcn(String icn)throws Exception{
	
		Validator v = ESAPI.validator();
		//we'll be optimistic as this parameter comes from internal sources
		boolean icnMatch = true;
					
		try{
			icnMatch = v.isValidInput(ICN_CHECKSUM_MATCH_PATTERN, icn, ICN_CHECKSUM_MATCH_PATTERN, 17, false);	
		}
		catch(Exception e){
			LOG.error(e);
			throw e;
		}
		
		return icnMatch;
	}
	

}
